<?php
require 'madeline.php';
use danog\MadelineProto\API;

$log_file = "batch_log.txt";

// تابع برای لاگ کردن
function write_log($text) {
    global $log_file;
    $time = date("Y-m-d H:i:s");
    file_put_contents($log_file, "[$time] $text\n", FILE_APPEND);
    echo "$text<br>";
}

$batch_size = 10; // تعداد مخاطب در هر بار اجرا

$MadelineProto = new API('session.madeline');
$MadelineProto->start();

$channel = '@mxlfe';

try {
    $channel_history = $MadelineProto->messages->getHistory([
        'peer' => $channel,
        'limit' => 1
    ]);
    $message_id = $channel_history['messages'][0]['id'];
    write_log("آیدی آخرین پیام کانال ($channel): $message_id");
} catch (Exception $e) {
    write_log("خطا در گرفتن پیام آخر کانال: " . $e->getMessage());
    exit;
}

// لیست همه مخاطبین را فقط از فایل می‌خوانیم:
if (!file_exists('contacts.json')) {
    write_log("فایل مخاطبین وجود ندارد. ابتدا اسکریپت ذخیره مخاطبین را اجرا کن.");
    exit;
}
$contacts_data = json_decode(file_get_contents('contacts.json'), true);
$user_ids = [];
foreach ($contacts_data['users'] as $user) {
    if (isset($user['id'])) {
        $user_ids[] = $user['id'];
    }
}

// اگر فایل batch باقی‌مانده وجود دارد، فقط همان‌ها را ارسال می‌کنیم:
if (file_exists('remaining_users.json')) {
    $user_ids = json_decode(file_get_contents('remaining_users.json'), true);
    write_log("لیست باقی‌مانده از فایل خوانده شد. تعداد: ".count($user_ids));
}

// انتخاب batch بعدی
$batch = array_splice($user_ids, 0, $batch_size);

write_log("تعداد ارسال در این اجرا: ".count($batch));

foreach ($batch as $user_id) {
    try {
        $MadelineProto->messages->forwardMessages([
            'from_peer' => $channel,
            'id' => [$message_id],
            'to_peer' => $user_id,
        ]);
        write_log("پیام برای کاربر با آیدی $user_id ارسال شد.");
        sleep(2);
    } catch (Exception $e) {
        write_log("خطا برای کاربر $user_id: ".$e->getMessage());
    }
}

// ذخیره مخاطبین باقی‌مانده برای اجرای بعدی
file_put_contents('remaining_users.json', json_encode($user_ids));

if (count($user_ids) === 0) {
    unlink('remaining_users.json');
    write_log("همه پیام‌ها ارسال شد و فایل remaining_users.json حذف شد.");
} else {
    write_log("batch ارسال شد، بقیه دفعات بعد ارسال می‌شوند. باقی‌مانده: ".count($user_ids));
}
?>
